function[times,patron]=heart_sound_detection_v3(x1,fs,T1,N1)

N=round(fs/8);
Nfft=2^nextpow2(N);
Poverl=0.5; Noverlap=round(Nfft*Poverl);
[S,F,T]=sg(x1,Nfft,fs,hanning(N),Noverlap);

% Se centrar la bsqueda en la banda 0-60 Hz fuera de la zona de
% solapamiento espectral entre sonidos de corazn y pulmn.
frequency=find(F<60);

K=length(T);
for i=2:K
      eu_d=sum(abs(S(frequency,i))-abs(S(frequency,i-1))); %[2]
      H=(eu_d+abs(eu_d))/2;
      R(i)=H;
end

%% Calculamos los picos de la funcin onset a travs del algoritmo AMPD
[peaks]=ampd(R);

[Cx,Lag]=xcorr(R); % [4]

peaks2=ampd(Cx(length(R)+1:end));
max_lateral=max(Cx((length(R)+peaks2(1)):end));
pos_max_lateral=find(Cx(length(R)+1:end)==max_lateral);
max_lateral_2=max(Cx((length(R)+pos_max_lateral+1):end));
pos_max_lateral_2=find(Cx(length(R)+1:end)==max_lateral_2);

%Con la siguiente condicin se asegura que los distancia entre sonidos
%iguales es mayor que un valor lgico de un latido de corazn.
if T(pos_max_lateral_2)>T(pos_max_lateral) && (T(pos_max_lateral_2)<1) && (T(pos_max_lateral_2)-T(pos_max_lateral))>0.4 
    periodo_estimado=T(pos_max_lateral_2+1);
else
    periodo_estimado=T(pos_max_lateral+1);
end


%% Tiempos donde se encuentran los sonidos de corazn
times=T(peaks);

%% Correccin primer pico

if (T(peaks(1))-periodo_estimado)>0
    times=[abs((T(peaks(1))-periodo_estimado));times];
    new_peak=abs((T(peaks(1))-periodo_estimado));
    new_peak_pos=find(T>=new_peak);
    peaks=[new_peak_pos(1),peaks];
elseif (T(peaks(2))-periodo_estimado)>0 && (T(peaks(2))-periodo_estimado)<T(peaks(1))
    times=[abs((T(peaks(2))-periodo_estimado));times];
    new_peak=abs((T(peaks(2))-periodo_estimado));
    new_peak_pos=find(T>new_peak);
    peaks=[(new_peak_pos(1)-1),peaks];
end

%% Creacin del patron en funcion de TNMF (T1)  y NNMF (N1)
times_T1=[];

for i=1:length(peaks)
    pos1=find(T(peaks(i))>T1);
    if isempty(pos1)
        pos1=[1,2,3];
    end
    pos2=find(T(peaks(i))<T1);
    
    if N1==512
        if length(pos1)>1
        aux=pos1(end-1):(pos2(1)+2);
        times_T1=[times_T1,aux];
        else
        aux=pos1(1):(pos2(1)+1);
        times_T1=[times_T1,aux];
        end
    elseif N1==1024
        if length(pos1)>1
        aux=pos1(end-1):(pos2(1)+1);
        times_T1=[times_T1,aux];
        else
        aux=pos1(1):(pos2(1)+1);
        times_T1=[times_T1,aux];
        end
    elseif N1==2048
        if length(pos1)>1
        aux=pos1(end-1):(pos2(1));
        times_T1=[times_T1,aux];
        else
        aux=pos1(1):(pos2(1));
        times_T1=[times_T1,aux];
        end
    end
end

patron=zeros(1,length(T1));
patron(round(times_T1))=1;
end
